<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getByParams(array $params)
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 */
class MilestoneManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单条里程碑
     *
     * @param  int $id 里程碑id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function get (int $id) {
        return self::getClass()->get([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部里程碑数据
     *
     * @param  array $sortBy 排序 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (array $sortBy) {
        return self::getClass()->all([
            "sortBy" => $sortBy,
        ]);
    }

    /**
     * 创建里程碑
     *
     * @support  string $name 名称 [ require false ]
     * @support  int $integral 纪念值 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑里程碑
     *
     * @support  int $id 里程碑id [ require false ]
     * @support  string $name 名称 [ require false ]
     * @support  int $integral 纪念值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\Milestone\MilestoneManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\Milestone\MilestoneManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}