<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method addByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getStaffsByPermissionByParams(array $params)
 */
class Permission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 创建权限
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  string $name 权限名 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $desc 描述 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 删除权限
     *
     * @support  int $id 权限id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 根据权限获取拥有该权限的所有员工
     *
     * @param  int $permission_id 权限id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffsByPermission (int $permission_id) {
        return self::getClass()->getStaffsByPermission([
            "permission_id" => $permission_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Auth\Permission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Auth\Permission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}