<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPreferentialPageActivityListByParams(array $params)
 * @method getMaintoProductByParams(array $params)
 * @method getCloudProductByParams(array $params)
 * @method getPeopleCountByParams(array $params)
 * @method upLoadImageByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 * @method getActivityAvailableStoreListByParams(array $params)
 * @method getAvailableStoreTreeByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method getMostNearestStoreByParams(array $params)
 * @method getMostNearestStoreByBrandByParams(array $params)
 * @method getActivityLinkParameterByParams(array $params)
 * @method saveActivityLinkParameterByParams(array $params)
 * @method getMiniUrlLinkByParams(array $params)
 * @method getQrcodeByParams(array $params)
 * @method getUnavailableStoreIdsByProductIdsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取领券活动页
     *
     * @support  string $category 分类 [ require false ]
     * @support  string $name 活动名称 [ require false ]
     * @support  string $template 模板key [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @support  bool $all 是否返回所有结果 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialPageActivityList () {
        return self::getClass()->getPreferentialPageActivityList([
        ]);
    }

    /**
     * 缦图产品列表
     *
     * @support  int $category_id 类目id [ require false ]
     * @support  string $name 产品名(模糊查询) [ require false ]
     * @support  string $full_name 产品全名(模糊查询) [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @support  string $module 产品所属模块 [ require false ]
     * @support  string $status 状态,会筛选子节点 [ require false ]
     * @support  bool $c_hidden 预约端是否隐藏,会筛选子节点 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaintoProduct () {
        return self::getClass()->getMaintoProduct([
        ]);
    }

    /**
     * 云端产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProduct () {
        return self::getClass()->getCloudProduct();
    }

    /**
     * 根据筛选条件获取人数
     *
     * @support  array $tags 标签数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPeopleCount () {
        return self::getClass()->getPeopleCount([
        ]);
    }

    /**
     * 上传图片
     *
     * @support  string $img_path 上传到又拍云后的图片地址 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upLoadImage () {
        return self::getClass()->upLoadImage([
        ]);
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 根据城市id获取门店企业微信信息
     *
     * @param  array $city_ids 城市ids [ require true ]
     * @param  array $store_type 门店类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreListByCityId (array $city_ids, array $store_type) {
        return self::getClass()->getStoreListByCityId([
            "city_ids" => $city_ids,
            "store_type" => $store_type,
        ]);
    }

    /**
     * 获取活动可用门店列表Ids
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @support  string $activity_type 活动类型 [ require false ]
     * @support  int $product_category_id 活动产品组id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityAvailableStoreList () {
        return self::getClass()->getActivityAvailableStoreList([
        ]);
    }

    /**
     * 获取可参与活动的门店树
     *
     * @support  int $product_category_id 产品组id [ require true ]
     * @support  string $brand 活动品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableStoreTree () {
        return self::getClass()->getAvailableStoreTree([
        ]);
    }

    /**
     * 批量获取产品的折扣规则
     *
     * @support  array $discount_rule_ids 折扣ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDiscountList () {
        return self::getClass()->getProductDiscountList([
        ]);
    }

    /**
     * 获取活动门店中距离最近的门店
     *
     * @support  array $location 地理位置,[125,30] [ require true ]
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $product_category_id 活动产品id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMostNearestStore () {
        return self::getClass()->getMostNearestStore([
        ]);
    }

    /**
     * 通过品牌获取最近的门店
     *
     * @support  array $location 地理位置,[125,30] [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMostNearestStoreByBrand () {
        return self::getClass()->getMostNearestStoreByBrand([
        ]);
    }

    /**
     * 获取活动链接参数
     *
     * @support  int $link_parameter_id 参数id [ require true ]
     * @support  int $index 链接参数下标 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getActivityLinkParameter () {
        return self::getClass()->getActivityLinkParameter([
        ]);
    }

    /**
     * 保存活动链接参数
     *
     * @support  mixed $activity_id 活动id [ require true ]
     * @support  array $link_parameter 活动链接参数 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function saveActivityLinkParameter () {
        return self::getClass()->saveActivityLinkParameter([
        ]);
    }

    /**
     * 获取微信小程序UrlLink
     *
     * @support  string $app_name 应用名称 [ require false ]
     * @support  string $path 小程序路径 [ require true ]
     * @support  string $query 路径参数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMiniUrlLink () {
        return self::getClass()->getMiniUrlLink([
        ]);
    }

    /**
     * 获取二维码
     *
     * @support  string $path 二维码路径 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getQrcode () {
        return self::getClass()->getQrcode([
        ]);
    }

    /**
     * 根据产品id列表获取禁用门店
     *
     * @support  array $product_ids 产品id列表 [ require true ]
     * @support  array $store_ids 活动品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUnavailableStoreIdsByProductIds () {
        return self::getClass()->getUnavailableStoreIdsByProductIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Common\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Common\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}