<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method addByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Template {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取模版列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page, int $page_size) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 新增模版
     *
     * @param  string $template_name 模版名称 [ require true ]
     * @param  string $description 模版描述 [ require true ]
     * @param  array $template_info 模版信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function add (string $template_name, string $description, array $template_info) {
        return self::getClass()->add([
            "template_name" => $template_name,
            "description" => $description,
            "template_info" => $template_info,
        ]);
    }

    /**
     * 删除模版
     *
     * @param  int $template_id 模版id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $template_id) {
        return self::getClass()->delete([
            "template_id" => $template_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Push\Template');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Push\Template');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}