<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createSpreadPlanByParams(array $params)
 * @method editSpreadPlanByParams(array $params)
 * @method cancelSpreadPlanByParams(array $params)
 * @method deleteSpreadPlanByParams(array $params)
 * @method spreadPlanDetailByParams(array $params)
 * @method spreadPlanListByParams(array $params)
 */
class SpreadPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建推广计划
     *
     * @support  string $task_name 任务名称 [ require true ]
     * @support  string $description 任务描述 
     * @support  string $brand 任务名称 
     * @support  string $relation_activity_id 关联活动编号 [ require true ]
     * @support  string $channel 任务推送渠道 [ require true ]
     * @support  string $push_at 推送时间 [ require true ]
     * @support  array $filter_condition 筛选条件 [ require true ]
     * @support  array $push_content 推送内容 [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSpreadPlan () {
        return self::getClass()->createSpreadPlan();
    }

    /**
     * 编辑推广计划
     *
     * @support  int $task_id 任务id [ require true ]
     * @support  string $brand 任务名称 
     * @support  string $task_name 任务名称 [ require true ]
     * @support  string $description 任务描述 
     * @support  string $relation_activity_id 关联活动编号 [ require true ]
     * @support  string $channel 任务推送渠道 [ require true ]
     * @support  string $push_at 推送时间 [ require true ]
     * @support  array $filter_condition 筛选条件 [ require true ]
     * @support  array $push_content 推送内容 [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editSpreadPlan () {
        return self::getClass()->editSpreadPlan();
    }

    /**
     * 推广计划取消
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelSpreadPlan (int $task_id) {
        return self::getClass()->cancelSpreadPlan([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 删除推广计划
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSpreadPlan (int $task_id) {
        return self::getClass()->deleteSpreadPlan([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 推广计划详情
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function spreadPlanDetail (int $task_id) {
        return self::getClass()->spreadPlanDetail([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 推广计划列表
     *
     * @support  string $status task状态 
     * @support  string $channel task渠道 
     * @support  string $task_name task名称 
     * @support  string $start_at 开始推送时间 
     * @support  string $end_at 结束推送时间 
     * @support  int $page task名称 
     * @support  int $page_size task名称 
     * @throws  \Exception
     * @return  array
     */
    public static function spreadPlanList () {
        return self::getClass()->spreadPlanList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Push\SpreadPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Push\SpreadPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}