<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMomentSettingByParams(array $params)
 * @method listByParams(array $params)
 * @method getMomentByParams(array $params)
 */
class Moment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取朋友圈页面设置
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMomentSetting () {
        return self::getClass()->getMomentSetting();
    }

    /**
     * 获取企业微信朋友圈列表
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取单条企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMoment () {
        return self::getClass()->getMoment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'WechatWork\Moment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'WechatWork\Moment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}