<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method bulkOpenByParams(array $params)
 * @method bulkForbiddenByParams(array $params)
 */
class MemberCardManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员卡列表--分页
     *
     * @support  string $receive_time_start 领取时间-开始时间 [ require false ]
     * @support  string $receive_time_end 领取时间-结束时间 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @support  string $user_name 用户名称 [ require false ]
     * @support  string $user_phone 用户手机号 [ require false ]
     * @support  string $template_title 会员卡名称 [ require false ]
     * @support  string $template_card_type 会员卡类型 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取会员卡详情
     *
     * @support  int $card_id 会员卡id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 批量开启会员卡
     *
     * @support  array $card_ids 批量开启的会员卡ID [ require true ]
     * @support  string $reason 开启原因 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkOpen () {
        return self::getClass()->bulkOpen([
        ]);
    }

    /**
     * 批量禁用会员卡
     *
     * @support  array $card_ids 批量开启的会员卡ID [ require true ]
     * @support  string $reason 开启原因 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkForbidden () {
        return self::getClass()->bulkForbidden([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\MemberCardManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\MemberCardManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}