<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ActivityRule;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRuleByParams(array $params)
 * @method getRuleByIdByParams(array $params)
 */
class ActivityRule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动规则
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @support  int $city_id 城市ID [ require true ]
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $product_group_id 产品组ID [ require true ]
     * @support  int $sponsor_id 发起人ID [ require false ]
     * @support  array $product_setting 产品配置 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createRule () {
        return self::getClass()->createRule([
        ]);
    }

    /**
     * 获取活动规则
     *
     * @support  string $rule_id 规则ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRuleById () {
        return self::getClass()->getRuleById([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ActivityRule\ActivityRule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ActivityRule\ActivityRule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}