<?php
namespace Mainto\Bridge\Enums\ProjectCrm;

class ActivityRuleEnum {
    /**
     * 加入活动次数限制
     */
    const JOIN_TIMES_LIMIT = 'rule.activity.join.times_limit';
    /**
     * 未发起过活动或者当前活动失败规则校验
     */
    const NEVER_JOIN_OR_STATUS_FAILED = 'rule.activity.join.never_join_or_status_failed';
    /**
     * 未加入过活动且发起人的人数未满
     */
    const NEVER_JOIN_AND_ACTIVITY_NOT_FULL = 'rule.activity.join.never_join_and_activity_not_full';
    /**
     * 加入活动前需要支付过订单校验
     */
    const NEED_ORDER_PAID_SUCCESS = 'rule.activity.join.need_order_paid_success';
    /**
     * 加入活动发放奖励
     */
    const JOIN_ACTIVITY = 'rule.activity.reward.join_activity';
    /**
     * 邀请到足够的用户发放奖励
     */
    const INVITE_USER_JOIN = 'rule.activity.reward.invite_user_join';
    /**
     * 邀请的受邀人支付订单发放奖励
     */
    const REGISTERED_USER_PAID_ORDER = 'rule.activity.reward.registered_user_paid_order';
    /**
     * 加入活动发放随机奖励
     */
    const JOIN_ACTIVITY_RANDOM_REWARD = 'rule.activity.reward.join_activity_random_reward';
    /**
     * 邀请用户加入阶段发放奖励
     */
    const INVITE_USER_JOIN_STAGE_REWARD = 'rule.activity.reward.invite_user_join_stage_reward';
    /**
     * 拼团活动规则
     */
    const NEVER_JOIN_AND_GROUP_BUY_NUM_REMAINING = 'rule.activity.join.never_join_and_group_buy_num_remaining';
    /**
     * 邀请用户发放积分或者纪念值
     */
    const INVITE_USER_REWARD_POINT = 'rule.activity.join.invite_user_reward_point';
    /**
     * 生日礼遇活动发起校验
     */
    const BIRTHDAY_GIFT_SPONSOR = 'rule.activity.join.birthday_gift_join';
    /**
     * 注册有礼活动发起人奖励
     */
    const REGISTER_HAVE_GIFT_SPONSOR = 'rule.activity.join.register_have_gift_join';
    /**
     * 每邀请X人发放奖励
     */
    const PER_INVITE_USER_REWARD = 'rule.activity.reward.per_invite_user_reward';
    /**
     * 虚拟权益随机奖励
     */
    const VIRTUAL_GIFT_RANDOM_REWARD = 'rule.activity.reward.virtual_gift_random_reward';
    /**
     * 加入活动需要虚拟奖励库存有剩余
     */
    const NEED_VIRTUAL_GIFT_COUNTER_REMAINING = 'rule.activity.join.need_virtual_gift_counter_remaining';
    /**
     * 需要新用户才能加入活动
     */
    const NEED_NEW_USERS = 'rule.activity.join.need_new_users';
    /**
     * 需要购买指定的产品
     */
    const NEED_PURCHASE_DESIGNATED_PRODUCTS = 'rule.activity.join.need_purchase_designated_products';
    /**
     * 奖品随机发放
     */
    const PRIZE_RANDOM_REWARD = 'rule.activity.reward.prize_random_reward';
    /**
     * 需要随机奖励库存有剩余
     */
    const NEED_RANDOM_PRIZE_COUNTER_REMAINING = 'rule.activity.join.need_random_prize_counter_remaining';
    /**
     * 受邀人加入中秋活动（临时规则--活动结束删除）
     */
    const INVITEE_JOIN_MID_AUTUMN_ACTIVITY = 'rule.activity.join.invitee_join_mid_autumn_activity';
    /**
     * 加入规则列表
     */
    const JOIN_RULE_LIST = [0 => 'rule.activity.join.times_limit',1 => 'rule.activity.join.never_join_or_status_failed',2 => 'rule.activity.join.never_join_and_activity_not_full',3 => 'rule.activity.join.need_order_paid_success',4 => 'rule.activity.join.never_join_and_group_buy_num_remaining',5 => 'rule.activity.join.need_new_users',6 => 'rule.activity.join.need_purchase_designated_products',7 => 'rule.activity.join.need_random_prize_counter_remaining',8 => 'rule.activity.join.invitee_join_mid_autumn_activity'];
    /**
     * 奖励规则列表
     */
    const REWARD_RULE_LIST = [0 => 'rule.activity.reward.join_activity',1 => 'rule.activity.reward.invite_user_join',2 => 'rule.activity.reward.registered_user_paid_order',3 => 'rule.activity.reward.join_activity_random_reward',4 => 'rule.activity.reward.invite_user_join_stage_reward',5 => 'rule.activity.join.invite_user_reward_point',6 => 'rule.activity.reward.per_invite_user_reward',7 => 'rule.activity.reward.virtual_gift_random_reward',8 => 'rule.activity.reward.prize_random_reward'];
}