<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method memberDiscountProductCategoriesListByParams(array $params)
 * @method getReceiveCouponActivityConfigByParams(array $params)
 * @method checkMemberStudentIdentifyByParams(array $params)
 * @method certifiedStudentIdentifyByParams(array $params)
 * @method receiveMemberCouponByParams(array $params)
 * @method getMemberCouponReceiveInfoByParams(array $params)
 * @method usedStudentCertificateTagByParams(array $params)
 */
class StudentMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员优惠产品类目列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberDiscountProductCategoriesList () {
        return self::getClass()->memberDiscountProductCategoriesList();
    }

    /**
     * 获取领券活动配置
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getReceiveCouponActivityConfig () {
        return self::getClass()->getReceiveCouponActivityConfig();
    }

    /**
     * 检查会员学生身份
     *
     * @throws  \Exception
     * @return  array
     */
    public static function checkMemberStudentIdentify () {
        return self::getClass()->checkMemberStudentIdentify();
    }

    /**
     * 认证学生身份
     *
     * @support  string $token 校验token [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function certifiedStudentIdentify () {
        return self::getClass()->certifiedStudentIdentify();
    }

    /**
     * 领取会员优惠券
     *
     * @support  int $template_id 会员卡模板id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveMemberCoupon () {
        return self::getClass()->receiveMemberCoupon();
    }

    /**
     * 获取会员优惠券领取信息
     *
     * @support  int $template_id 会员卡模板id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMemberCouponReceiveInfo () {
        return self::getClass()->getMemberCouponReceiveInfo();
    }

    /**
     * 使用学生认证标签
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function usedStudentCertificateTag () {
        return self::getClass()->usedStudentCertificateTag();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\StudentMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\StudentMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}