<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponListByParams(array $params)
 * @method getProductCardListByParams(array $params)
 * @method getGiftCardListByParams(array $params)
 * @method getFlowListByParams(array $params)
 * @method allPropertyByParams(array $params)
 * @method searchGiftCardDetailsByParams(array $params)
 * @method getMedalListByParams(array $params)
 */
class MemberProperty {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 按品牌获取优惠券列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $brand 品牌 require false
     * @support  string $status 券码状态 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponList () {
        return self::getClass()->getCouponList();
    }

    /**
     * 按品牌获取产品卡列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $brand 品牌 require false
     * @support  string $status 券码状态 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCardList () {
        return self::getClass()->getProductCardList();
    }

    /**
     * 按品牌获取礼品卡列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $brand 品牌 require false
     * @support  string $status 券码状态 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardList () {
        return self::getClass()->getGiftCardList();
    }

    /**
     * 获取用户流水
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  array $types 类型 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getFlowList () {
        return self::getClass()->getFlowList();
    }

    /**
     * 获取资产汇总信息
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allProperty (int $user_id) {
        return self::getClass()->allProperty([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取礼品卡使用明细
     *
     * @support  int $gift_card_id 礼品卡ID [ require true ]
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchGiftCardDetails () {
        return self::getClass()->searchGiftCardDetails();
    }

    /**
     * 获取勋章明细
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMedalList () {
        return self::getClass()->getMedalList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\MemberProperty');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\MemberProperty');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}