<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ActivityPage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByIdByParams(array $params)
 * @method receiveCouponByParams(array $params)
 * @method receiveCouponByAuthByParams(array $params)
 * @method getJsSdkByParams(array $params)
 * @method appointmentReceiveCouponByAuthByParams(array $params)
 */
class ActivityPage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 单个活动查询[用户端]
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchById (string $_id) {
        return self::getClass()->searchById([
            "_id" => $_id,
        ]);
    }

    /**
     * 用户领券 - 通过手机号验证码
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $receiveChannel 领取渠道 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveCoupon (string $_id, string $phone, string $code = '', string $receiveChannel = '') {
        return self::getClass()->receiveCoupon([
            "_id" => $_id,
            "phone" => $phone,
            "code" => $code,
            "receiveChannel" => $receiveChannel,
        ]);
    }

    /**
     * 用户领券 - 需授权登录
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $receiveChannel 领取渠道 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveCouponByAuth (string $_id, string $phone, string $receiveChannel = '') {
        return self::getClass()->receiveCouponByAuth([
            "_id" => $_id,
            "phone" => $phone,
            "receiveChannel" => $receiveChannel,
        ]);
    }

    /**
     * 获取微信签名jssdk配置
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $url 活动链接 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getJsSdk (string $_id, string $url) {
        return self::getClass()->getJsSdk([
            "_id" => $_id,
            "url" => $url,
        ]);
    }

    /**
     * 预约端专用 - 用户领券.鉴权
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function appointmentReceiveCouponByAuth (string $_id, string $phone) {
        return self::getClass()->appointmentReceiveCouponByAuth([
            "_id" => $_id,
            "phone" => $phone,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ActivityPage\ActivityPage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ActivityPage\ActivityPage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}