<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\BirthDayGift;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receiveCouponByParams(array $params)
 * @method modifyUserBirthByParams(array $params)
 */
class BirthDayGiftActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 领取生日礼遇优惠券
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveCoupon () {
        return self::getClass()->receiveCoupon();
    }

    /**
     * 完善用户生日资料
     *
     * @support  string $birth 生日，例：1996-10-12 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyUserBirth () {
        return self::getClass()->modifyUserBirth();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'BirthDayGift\BirthDayGiftActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'BirthDayGift\BirthDayGiftActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}