<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method memberListByParams(array $params)
 * @method memberElementaryMessageByParams(array $params)
 * @method memberEsMessageByParams(array $params)
 * @method memberOrderListByParams(array $params)
 * @method memberDiscountProductCategoriesListByParams(array $params)
 */
class Member {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员列表
     *
     * @support  string $user_sex 性别，男，女，未知 require false
     * @support  string $regis_source 注册来源 require false
     * @support  array $attent_pub_account 关注列表 require false
     * @support  string $user_level 会员等级 require false
     * @support  array $user_levels 会员等级集合 require false
     * @support  array $life_circle_label 生命周期标签 require false
     * @support  string $user_phone 用户手机号 require false
     * @support  string $register_start 注册开始时间 require false
     * @support  string $register_end 注册结束时间 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @support  string $sort_by 排序字段 [ require true ]
     * @support  string $sort_type 排序字段 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberList () {
        return self::getClass()->memberList();
    }

    /**
     * 获取会员基础信息
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberElementaryMessage (int $user_id) {
        return self::getClass()->memberElementaryMessage([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取会员聚合信息(从es获取的统计类数据)
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberEsMessage (int $user_id) {
        return self::getClass()->memberEsMessage([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 按品牌获取订单列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $brand 品牌 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberOrderList () {
        return self::getClass()->memberOrderList();
    }

    /**
     * 获取会员优惠产品类目列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberDiscountProductCategoriesList () {
        return self::getClass()->memberDiscountProductCategoriesList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\Member');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\Member');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}