<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createTemplateByParams(array $params)
 * @method updateTemplateByParams(array $params)
 * @method modifyTemplateStateByParams(array $params)
 * @method listByParams(array $params)
 */
class MemberCardTemplateManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员卡详情
     *
     * @support  int $template_id 会员卡模板id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 创建会员卡模板
     *
     * @support  string $title 会员卡名称 [ require true ]
     * @support  string $card_type 会员卡类型 [ require true ]
     * @support  string $identity 会员身份 [ require true ]
     * @support  mixed $total 会员卡发行数量 require false
     * @support  string $push_time 发行时间 [ require true ]
     * @support  string $gain_type 权益类型 [ require true ]
     * @support  array $gain_config 权益配置 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createTemplate () {
        return self::getClass()->createTemplate();
    }

    /**
     * 编辑会员卡模板
     *
     * @support  int $template_id 会员模板ID [ require true ]
     * @support  string $title 会员卡名称 [ require true ]
     * @support  string $card_type 会员卡类型 [ require true ]
     * @support  string $identity 会员身份 [ require true ]
     * @support  mixed $total 会员卡发行数量 require false
     * @support  string $push_time 发行时间 [ require true ]
     * @support  string $gain_type 权益类型 [ require true ]
     * @support  array $gain_config 权益配置 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTemplate () {
        return self::getClass()->updateTemplate();
    }

    /**
     * 修改会员卡模板状态
     *
     * @support  int $template_id 会员卡模板id [ require true ]
     * @support  string $state 修改后的会员卡状态 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyTemplateState () {
        return self::getClass()->modifyTemplateState();
    }

    /**
     * 获取会员卡模板列表--分页
     *
     * @support  string $type 会员卡类型 require false
     * @support  string $state 状态，released = 已发行，await_released = 待发行，down = 已下架 require false
     * @support  string $template_name 会员卡模板名称 require false
     * @support  string $release_start_time 发行时间 - 开始日期 require false
     * @support  string $release_end_time 发行时间 - 结束日期 require false
     * @support  string $create_start_time 创建时间 - 开始日期 require false
     * @support  string $create_end_time 创建时间 - 结束日期 require false
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\MemberCardTemplateManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\MemberCardTemplateManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}