<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method memberDiscountProductCategoriesListByParams(array $params)
 * @method checkMemberStudentIdentifyByParams(array $params)
 * @method saveMemberEducationInfoByParams(array $params)
 */
class StudentMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员优惠产品类目列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberDiscountProductCategoriesList () {
        return self::getClass()->memberDiscountProductCategoriesList();
    }

    /**
     * 检查会员学生身份
     *
     * @throws  \Exception
     * @return  array
     */
    public static function checkMemberStudentIdentify () {
        return self::getClass()->checkMemberStudentIdentify();
    }

    /**
     * 保存会员教育信息
     *
     * @support  string $degree 学历 [ require true ]
     * @support  string $enroll_date 入学年份 require false
     * @support  string $school_name 学校名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveMemberEducationInfo () {
        return self::getClass()->saveMemberEducationInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\StudentMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\StudentMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}