<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method handleActivityOrderPaidByParams(array $params)
 * @method handleActivityOrderRefundByParams(array $params)
 * @method handleActivityOrderCancelByParams(array $params)
 * @method inviteeJoinRewardSponsorByParams(array $params)
 * @method resetMemberEffectiveTimeByParams(array $params)
 * @method handleActivityPeriodExpireByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 处理活动订单支付成功事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderPaid () {
        return self::getClass()->handleActivityOrderPaid();
    }

    /**
     * 处理活动订单退款事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $refundId 退款id require false
     * @support  int $storeId 门店id require false
     * @support  string $oriOrderStatus 源订单状态 require false
     * @support  array $orderBaseInfo 订单基础信息 require false
     * @support  array $closedSaleIds 退款产品id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderRefund () {
        return self::getClass()->handleActivityOrderRefund();
    }

    /**
     * 处理活动订单取消事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderCancel () {
        return self::getClass()->handleActivityOrderCancel();
    }

    /**
     * 受邀者加入奖励发起者
     *
     * @support  array $invitee 受邀人数据 [ require true ]
     * @support  array $sponsor 邀请人数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inviteeJoinRewardSponsor () {
        return self::getClass()->inviteeJoinRewardSponsor();
    }

    /**
     * 重置活动发起人的活动有效时间
     *
     * @support  array $sponsors 活动成员 [ require true ]
     * @support  string $effectiveEndedTime 截止的活动有效时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetMemberEffectiveTime () {
        return self::getClass()->resetMemberEffectiveTime();
    }

    /**
     * 处理发起人活动周期到期的schedule
     *
     * @support  array $schedule 活动schdule [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityPeriodExpire () {
        return self::getClass()->handleActivityPeriodExpire();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}