<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInviteGifsCurrentByParams(array $params)
 * @method getInviteGifsHistoryByParams(array $params)
 */
class InviteHaveGift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查找当前活动的邀请人数列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getInviteGifsCurrent () {
        return self::getClass()->getInviteGifsCurrent();
    }

    /**
     * 查找当前活动的历史邀请人数列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getInviteGifsHistory () {
        return self::getClass()->getInviteGifsHistory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\InviteHaveGift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\InviteHaveGift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}