<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method checkFamilyInviteJoinActivityByParams(array $params)
 * @method getMemberRewardDetailByParams(array $params)
 * @method getActivityQrcodeByParams(array $params)
 */
class FamilyInviteJoinActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取family助力活动详情
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 检查Family助力活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkFamilyInviteJoinActivity () {
        return self::getClass()->checkFamilyInviteJoinActivity();
    }

    /**
     * 获取成员的虚拟奖励详情--family端调用获取用户的虚拟奖励用于发礼品卡
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getMemberRewardDetail () {
        return self::getClass()->getMemberRewardDetail();
    }

    /**
     * 获取family助力二维码
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  string $path 小程序路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityQrcode () {
        return self::getClass()->getActivityQrcode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\FamilyInviteJoinActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\FamilyInviteJoinActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}