<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method modifyUserBaseProfileByParams(array $params)
 * @method getCouponGiveInfoByParams(array $params)
 */
class RegisterHaveGift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 完善用户基础信息
     *
     * @support  string $birth 生日，例：1996-10-12 require false
     * @support  string $sex 性别，female=女，male=男 require false
     * @support  int $position_id 职业ID require false
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyUserBaseProfile () {
        return self::getClass()->modifyUserBaseProfile();
    }

    /**
     * 获取优惠券发放信息
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponGiveInfo () {
        return self::getClass()->getCouponGiveInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\RegisterHaveGift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\RegisterHaveGift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}