<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityByParams(array $params)
 * @method joinActivityByParams(array $params)
 * @method getSponsorActivityInfoByParams(array $params)
 * @method getInviteeActivityInfoByParams(array $params)
 * @method canJoinByNeedConsumeByParams(array $params)
 * @method canJoinByRegisteredFromByParams(array $params)
 * @method joinGroupListByParams(array $params)
 * @method checkActivityInfoByParams(array $params)
 * @method checkLimitedTimeBuyByParams(array $params)
 * @method checkActivityInfoForWebByParams(array $params)
 * @method groupBuyOrderListByParams(array $params)
 * @method saveGroupBuyItemsByParams(array $params)
 * @method getGroupBuyItemsByParams(array $params)
 * @method searchUserGroupBuySubmittedOrderByParams(array $params)
 * @method findInvitedHistoryRecordsByParams(array $params)
 * @method findInvitedRecordsByParams(array $params)
 * @method discountProductCategoryListByParams(array $params)
 * @method canReservationAnytimeByParams(array $params)
 * @method checkProductParticipateStoreByParams(array $params)
 * @method getStoreDiscountRulesByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单个活动详情
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  string $type 活动类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivity () {
        return self::getClass()->getActivity();
    }

    /**
     * 用户加入活动
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  mixed $user_info 用户信息 [ require true ]
     * @support  int $member_id 邀请人的member_id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 获取活动发起者的活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 活动发起者id require false
     * @support  bool $with_relation_members 是否展示受邀人的信息 require false
     * @support  string $relation_members_sort 受邀人列表排序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSponsorActivityInfo () {
        return self::getClass()->getSponsorActivityInfo();
    }

    /**
     * 获取活动助力者的活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $member_id 活动发起者的member_id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInviteeActivityInfo () {
        return self::getClass()->getInviteeActivityInfo();
    }

    /**
     * 校验当前用户是否需要消费才能加入活动
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $is_sponsor 是否是发起人加入 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function canJoinByNeedConsume () {
        return self::getClass()->canJoinByNeedConsume();
    }

    /**
     * 校验当前用户是否是当前活动品牌的新用户
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canJoinByRegisteredFrom () {
        return self::getClass()->canJoinByRegisteredFrom();
    }

    /**
     * 获取拼团列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinGroupList () {
        return self::getClass()->joinGroupList();
    }

    /**
     * 检查活动信息--预约端调用
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  float $group_buy_discount 拼团折扣（拼团之后使用组合优惠的规则不再校验活动配置的拼团折扣） require false
     * @support  array $group_buy_products 拼团活动产品 require false
     * @support  array $products_detail 产品详情 require false
     * @support  int $user_id 用户id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function checkActivityInfo () {
        return self::getClass()->checkActivityInfo();
    }

    /**
     * 检查限时购活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  array $products_detail 产品详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkLimitedTimeBuy () {
        return self::getClass()->checkLimitedTimeBuy();
    }

    /**
     * 检查活动信息--web
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkActivityInfoForWeb () {
        return self::getClass()->checkActivityInfoForWeb();
    }

    /**
     * 用户拼团订单列表
     *
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupBuyOrderList () {
        return self::getClass()->groupBuyOrderList();
    }

    /**
     * 保存用户拼团的项目
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  array $items 团购项目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveGroupBuyItems () {
        return self::getClass()->saveGroupBuyItems();
    }

    /**
     * 获取用户拼团的项目
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupBuyItems () {
        return self::getClass()->getGroupBuyItems();
    }

    /**
     * 查找用户未支付的团购订单
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUserGroupBuySubmittedOrder () {
        return self::getClass()->searchUserGroupBuySubmittedOrder();
    }

    /**
     * 查找用户的历史邀请记录
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function findInvitedHistoryRecords () {
        return self::getClass()->findInvitedHistoryRecords();
    }

    /**
     * 查找用户当前活动的邀请记录
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 require false
     * @support  int $page_size 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function findInvitedRecords () {
        return self::getClass()->findInvitedRecords();
    }

    /**
     * 获取活动折扣产品组列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function discountProductCategoryList () {
        return self::getClass()->discountProductCategoryList();
    }

    /**
     * 是否可以任意时间段内预约
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canReservationAnytime () {
        return self::getClass()->canReservationAnytime();
    }

    /**
     * 检查产品是否参与限时购门店折扣
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  array $products 产品信息列表 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkProductParticipateStore () {
        return self::getClass()->checkProductParticipateStore();
    }

    /**
     * 获取当前门店下的活动优惠规则--限时购活动使用
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreDiscountRules () {
        return self::getClass()->getStoreDiscountRules();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}