<?php
namespace Mainto\Bridge\Enums\ProjectCrm;

class ActivityEnum {
    /**
     * 活动状态
     */
    const ACTIVITY_NOT_STATED = 0;
    const ACTIVITY_PROCESSING = 1;
    const ACTIVITY_FINISHED = 2;
    /**
     * 活动成员状态
     */
    const ACTIVITY_MEMBER_STATUS_PROCESSING = 'processing';
    const ACTIVITY_MEMBER_STATUS_SUCCESS = 'success';
    /**
     * 活动类型
     */
    const ACTIVITY_TYPE_INVITE_JOIN = 'invite_join';
    const ACTIVITY_TYPE_INVITE_REGISTER = 'invite_register';
    const ACTIVITY_TYPE_REGISTER_HAVE_GIFT = 'register_have_gift';
    const ACTIVITY_TYPE_JOIN_GROUP = 'join_group';
    const ACTIVITY_TYPE_WECHAT_WORK = 'wechat_work';
    const ACTIVITY_TYPE_BIRTHDAY_GIFT = 'birthday_gift';
    const ACTIVITY_TYPE_LIMITED_TIME_BUY = 'limited_time_buy';
    const ACTIVITY_TYPE_INVITE_HAVE_GIFT = 'invite_have_gift';
    /**
     * 活动品牌
     */
    const ACTIVITY_BRAND_HIMO = 'himo';
    const ACTIVITY_BRAND_MASTER = 'gold';
    const ACTIVITY_BRAND_KIDS = 'kids';
    const ACTIVITY_BRAND_HIMO_MASTER = 'himo_gold';
    /**
     * 品牌类型 map
     */
    const ACTIVITY_BRAND_LIST = [0 => 'himo',1 => 'kids',2 => 'gold',3 => 'himo_gold'];
    /**
     * 活动类型 map
     */
    const ACTIVITY_TYPE_LIST = [0 => 'invite_join',1 => 'invite_register',2 => 'join_group',3 => 'wechat_work',4 => 'register_have_gift',5 => 'limited_time_buy',6 => 'invite_have_gift'];
    /**
     * 活动品牌转门店类型 map
     */
    const ACTIVITY_BRAND_TO_STORE_TYPE_MAP = ['himo_gold' => [0 => 'blue',1 => 'gold'],'kids' => [0 => 'kids'],'himo' => [0 => 'blue'],'gold' => [0 => 'gold']];
}