<?php
namespace Mainto\Bridge\Enums\ProjectCrm;

class ActivityEnum {
    const ACTIVITY_NOT_STATED = 0;
    const ACTIVITY_PROCESSING = 1;
    const ACTIVITY_FINISHED = 2;
    const ACTIVITY_MEMBER_STATUS_PROCESSING = 'processing';
    const ACTIVITY_MEMBER_STATUS_SUCCESS = 'success';
    const ACTIVITY_TYPE_INVITE_JOIN = 'invite_join';
    const ACTIVITY_TYPE_INVITE_REGISTER = 'invite_register';
    const ACTIVITY_TYPE_REGISTER_HAVE_GIFT = 'register_have_gift';
    const ACTIVITY_TYPE_JOIN_GROUP = 'join_group';
    const ACTIVITY_TYPE_WECHAT_WORK = 'wechat_work';
    const ACTIVITY_TYPE_BIRTHDAY_GIFT = 'birthday_gift';
    const ACTIVITY_TYPE_LIMITED_TIME_BUY = 'limited_time_buy';
    const ACTIVITY_INVITE_JOIN_CHANNEL_PREFIX = '101';
    const ACTIVITY_INVITE_REGISTER_CHANNEL_PREFIX = '102';
    const ACTIVITY_BIRTHDAY_GIFT_CHANNEL_PREFIX = '103';
    const ACTIVITY_REGISTER_HAVE_GIFT_CHANNEL_PREFIX = '104';
    const ACTIVITY_BRAND_HIMO_SUFFIX = '01';
    const ACTIVITY_BRAND_KIDS_SUFFIX = '02';
    const ACTIVITY_BRAND_MASTER_SUFFIX = '03';
    const ACTIVITY_BRAND_HIMO = 'himo';
    const ACTIVITY_BRAND_MASTER = 'gold';
    const ACTIVITY_BRAND_KIDS = 'kids';
    const ACTIVITY_BRAND_HIMO_MASTER = 'himo_gold';
    const ACTIVITY_BRAND_LIST = [0 => 'himo',1 => 'kids',2 => 'gold',3 => 'himo_gold'];
    const ACTIVITY_TYPE_LIST = [0 => 'invite_join',1 => 'invite_register',2 => 'join_group',3 => 'wechat_work',4 => 'register_have_gift',5 => 'limited_time_buy'];
    /**
     * 根据活动类型生成小程序码枚举
     */
    const ACTIVITY_TYPE_MINI_QRCODE = ['join_group' => 'crm_app','limited_time_buy' => 'crm_app','register_have_gift' => 'himo_app'];
    /**
     * 活动品牌转门店类型map
     */
    const ACTIVITY_BRAND_TO_STORE_TYPE_MAP = ['himo_gold' => [0 => 'blue',1 => 'gold'],'kids' => [0 => 'kids'],'himo' => [0 => 'blue'],'gold' => [0 => 'gold']];
}