<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method spreadPlanPushTaskByParams(array $params)
 * @method messageTouchPushTaskByParams(array $params)
 * @method cronTestByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 推广任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function spreadPlanPushTask () {
        return self::getClass()->spreadPlanPushTask();
    }

    /**
     * 消息触达
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTouchPushTask () {
        return self::getClass()->messageTouchPushTask();
    }

    /**
     * 定时任务测试发送
     *
     * @param  string $type msg_touch|spread_plan [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest (string $type) {
        return self::getClass()->cronTest([
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Cron\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Cron\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}