<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPreferentialPageActivityListByParams(array $params)
 * @method getMaintoProductByParams(array $params)
 * @method getCloudProductByParams(array $params)
 * @method getPeopleCountByParams(array $params)
 * @method upLoadImageByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 * @method getJoinGroupActivityAvailableStoreListByParams(array $params)
 * @method getAvailableStoreTreeByParams(array $params)
 * @method getProductDiscountByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取领券活动页
     *
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  string $status 状态 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @support  bool $all 是否返回所有结果 
     * @throws  \Exception
     * @return  array
     */
    public static function getPreferentialPageActivityList () {
        return self::getClass()->getPreferentialPageActivityList();
    }

    /**
     * 缦图产品列表
     *
     * @support  int $category_id 类目id 
     * @support  string $name 产品名(模糊查询) 
     * @support  string $full_name 产品全名(模糊查询) 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $module 产品所属模块 
     * @support  string $status 状态,会筛选子节点 
     * @support  bool $c_hidden 预约端是否隐藏,会筛选子节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaintoProduct () {
        return self::getClass()->getMaintoProduct();
    }

    /**
     * 云端产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProduct () {
        return self::getClass()->getCloudProduct();
    }

    /**
     * 根据筛选条件获取人数
     *
     * @support  array $tags 标签数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getPeopleCount () {
        return self::getClass()->getPeopleCount();
    }

    /**
     * 上传图片
     *
     * @support  string $img_path 上传到又拍云后的图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function upLoadImage () {
        return self::getClass()->upLoadImage();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 根据城市id获取门店企业微信信息
     *
     * @param  array $city_ids 城市ids [ require true ]
     * @param  array $store_type 门店类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreListByCityId (array $city_ids, array $store_type) {
        return self::getClass()->getStoreListByCityId([
            "city_ids" => $city_ids,
            "store_type" => $store_type,
        ]);
    }

    /**
     * 获取拼团活动可用门店列表Ids
     *
     * @support  int $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getJoinGroupActivityAvailableStoreList () {
        return self::getClass()->getJoinGroupActivityAvailableStoreList();
    }

    /**
     * 获取可参与活动的门店树
     *
     * @support  int $product_category_id 产品组id [ require true ]
     * @support  string $brand 活动品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableStoreTree () {
        return self::getClass()->getAvailableStoreTree();
    }

    /**
     * 获取产品的折扣规则
     *
     * @support  int $discount_rule_id 折扣id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDiscount () {
        return self::getClass()->getProductDiscount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Common\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Common\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}