<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getMomentByParams(array $params)
 * @method deleteMomentByParams(array $params)
 * @method updateMomentByParams(array $params)
 * @method createMomentByParams(array $params)
 * @method getMomentSettingByParams(array $params)
 * @method saveMomentSettingByParams(array $params)
 */
class MomentManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取企业微信朋友圈列表
     *
     * @support  string $type 朋友圈类型 
     * @support  string $published_started_at 开始时间 
     * @support  string $published_ended_at 结束时间 
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取单条企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMoment () {
        return self::getClass()->getMoment();
    }

    /**
     * 删除企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteMoment () {
        return self::getClass()->deleteMoment();
    }

    /**
     * 编辑企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @support  string $type 朋友圈类型 [ require true ]
     * @support  string $content 朋友圈内容 
     * @support  array $store_ids 朋友圈发布范围 [ require true ]
     * @support  string $published_at 发布时间 
     * @support  array $material 朋友圈内容素材 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateMoment () {
        return self::getClass()->updateMoment();
    }

    /**
     * 创建企业微信朋友圈
     *
     * @support  string $type 朋友圈类型 [ require true ]
     * @support  string $content 朋友圈内容 
     * @support  array $store_ids 朋友圈发布范围 [ require true ]
     * @support  string $published_at 发布时间 
     * @support  array $material 朋友圈内容素材 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createMoment () {
        return self::getClass()->createMoment();
    }

    /**
     * 获取朋友圈页面设置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMomentSetting () {
        return self::getClass()->getMomentSetting();
    }

    /**
     * 保存朋友圈页面设置
     *
     * @support  string $background 页面背景 [ require true ]
     * @support  string $nickname 昵称 [ require true ]
     * @support  string $signature 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveMomentSetting () {
        return self::getClass()->saveMomentSetting();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'WechatWork\MomentManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'WechatWork\MomentManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}