<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pushActivityScheduleMsgByParams(array $params)
 * @method handleActivityPeriodExpireByParams(array $params)
 * @method handleGroupBuyNumEmptyByParams(array $params)
 */
class ActivityCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天9点执行一次，将0-9点之间的活动消息推送给用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushActivityScheduleMsg () {
        return self::getClass()->pushActivityScheduleMsg();
    }

    /**
     * 每分钟执行一次，查询需要处理发起人活动周期到期的schedule
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityPeriodExpire () {
        return self::getClass()->handleActivityPeriodExpire();
    }

    /**
     * 每5分钟执行一次，处理拼团活动库存清零后将发起人虚拟成团
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleGroupBuyNumEmpty () {
        return self::getClass()->handleGroupBuyNumEmpty();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\ActivityCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\ActivityCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}