<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActivityByParams(array $params)
 * @method updateActivityByParams(array $params)
 * @method listByParams(array $params)
 * @method getActivityByParams(array $params)
 */
class ActivityManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动
     *
     * @support  string $brand 活动品牌 [ require true ]
     * @support  string $title 活动标题 [ require true ]
     * @support  string $type 活动类型 [ require true ]
     * @support  string $started_at 开始时间 [ require true ]
     * @support  string $ended_at 结束时间 [ require true ]
     * @support  array $page_setting 页面配置 
     * @support  array $rule_setting 规则配置 
     * @support  array $extend 扩展数据 
     * @throws  \Exception
     * @return  array
     */
    public static function createActivity () {
        return self::getClass()->createActivity();
    }

    /**
     * updateActivity
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateActivity () {
        return self::getClass()->updateActivity();
    }

    /**
     * 获取活动列表列表
     *
     * @support  string $brand 活动品牌 
     * @support  int $status 活动状态 
     * @support  string $title 活动标题 
     * @support  int $activity_id 活动id 
     * @support  string $type 活动类型 
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取活动列表列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity () {
        return self::getClass()->getActivity();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\ActivityManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\ActivityManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}