<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityByParams(array $params)
 * @method joinActivityByParams(array $params)
 * @method getSponsorActivityInfoByParams(array $params)
 * @method getInviteeActivityInfoByParams(array $params)
 * @method canJoinByNeedConsumeByParams(array $params)
 * @method canJoinByRegisteredFromByParams(array $params)
 * @method joinGroupListByParams(array $params)
 * @method checkActivityInfoByParams(array $params)
 * @method groupBuyOrderListByParams(array $params)
 * @method saveGroupBuyItemsByParams(array $params)
 * @method getGroupBuyItemsByParams(array $params)
 * @method searchUserGroupBuySubmittedOrderByParams(array $params)
 * @method findInvitedHistoryRecordsByParams(array $params)
 * @method findInvitedRecordsByParams(array $params)
 * @method handleInviteRegisterOrderPaidByParams(array $params)
 * @method handleJoinGroupOrderPaidByParams(array $params)
 * @method inviteeJoinRewardSponsorByParams(array $params)
 * @method handleActivityPeriodExpireByParams(array $params)
 * @method handleCancelJoinGroupOrderByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单个活动详情
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity () {
        return self::getClass()->getActivity();
    }

    /**
     * 用户加入活动
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  mixed $user_info 用户信息 [ require true ]
     * @support  int $member_id 邀请人的member_id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 获取活动发起者的活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 活动发起者id 
     * @support  bool $with_relation_members 是否展示受邀人的信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getSponsorActivityInfo () {
        return self::getClass()->getSponsorActivityInfo();
    }

    /**
     * 获取活动助力者的活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $member_id 活动发起者的member_id 
     * @throws  \Exception
     * @return  array
     */
    public static function getInviteeActivityInfo () {
        return self::getClass()->getInviteeActivityInfo();
    }

    /**
     * 校验当前用户是否需要消费才能加入活动
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $is_sponsor 是否是发起人加入 
     * @throws  \Exception
     * @return  array
     */
    public static function canJoinByNeedConsume () {
        return self::getClass()->canJoinByNeedConsume();
    }

    /**
     * 校验当前用户是否是当前活动品牌的新用户
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function canJoinByRegisteredFrom () {
        return self::getClass()->canJoinByRegisteredFrom();
    }

    /**
     * 获取拼团列表
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function joinGroupList () {
        return self::getClass()->joinGroupList();
    }

    /**
     * 检查活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  float $group_buy_discount 拼团折扣 [Original type unsignedDouble] 
     * @support  array $group_buy_products 拼团活动产品 
     * @support  int $user_id 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkActivityInfo () {
        return self::getClass()->checkActivityInfo();
    }

    /**
     * 用户拼团订单列表
     *
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function groupBuyOrderList () {
        return self::getClass()->groupBuyOrderList();
    }

    /**
     * 保存用户拼团的项目
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  array $items 团购项目 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function saveGroupBuyItems () {
        return self::getClass()->saveGroupBuyItems();
    }

    /**
     * 获取用户拼团的项目
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupBuyItems () {
        return self::getClass()->getGroupBuyItems();
    }

    /**
     * 查找用户未支付的团购订单
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchUserGroupBuySubmittedOrder () {
        return self::getClass()->searchUserGroupBuySubmittedOrder();
    }

    /**
     * 查找用户的历史邀请记录
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function findInvitedHistoryRecords () {
        return self::getClass()->findInvitedHistoryRecords();
    }

    /**
     * 查找用户当前活动的邀请记录
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function findInvitedRecords () {
        return self::getClass()->findInvitedRecords();
    }

    /**
     * 处理邀请注册活动的订单支付成功事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleInviteRegisterOrderPaid () {
        return self::getClass()->handleInviteRegisterOrderPaid();
    }

    /**
     * 处理拼团活动的订单支付成功事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleJoinGroupOrderPaid () {
        return self::getClass()->handleJoinGroupOrderPaid();
    }

    /**
     * 受邀者加入奖励发起者
     *
     * @support  array $invitee 受邀人数据 [ require true ]
     * @support  array $sponsor 邀请人数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inviteeJoinRewardSponsor () {
        return self::getClass()->inviteeJoinRewardSponsor();
    }

    /**
     * 处理发起人活动周期到期的schedule
     *
     * @support  array $schedule 活动schdule [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityPeriodExpire () {
        return self::getClass()->handleActivityPeriodExpire();
    }

    /**
     * 处理取消拼团活动的订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleCancelJoinGroupOrder () {
        return self::getClass()->handleCancelJoinGroupOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}