<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityByParams(array $params)
 * @method joinActivityByParams(array $params)
 * @method getSponsorActivityInfoByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单个活动详情
     *
     * @support  int $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity () {
        return self::getClass()->getActivity();
    }

    /**
     * 用户加入活动
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $member_id 邀请人的member_id 
     * @support  array $user_info 用户信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 获取活动发起者的活动信息
     *
     * @support  int $activity_id 活动id [ require true ]
     * @support  int $user_id 活动发起者id 
     * @throws  \Exception
     * @return  array
     */
    public static function getSponsorActivityInfo () {
        return self::getClass()->getSponsorActivityInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}