<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-14 10:40:10
 */
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetoucherStream
 */
class RetoucherStream {
    private static string $serviceName = "ProjectCloud3rd";

    private static string $className = "Retoucher\\RetoucherStream";

    /**
     * 获取流水详情
     *
     */
    public static function getRetoucherStream (int $retoucherStreamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherStream(["retoucherStreamId" => $retoucherStreamId, ]);
    }
    /**
     * 获取修片流水记录列表
     *
     */
    public static function getRetoucherStreamList (int $page, int $pageSize, string $cloudReviewTimeStart, string $cloudReviewTimeEnd, int $plant, int $pull, string $state, int $star) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherStreamList(["page" => $page, "pageSize" => $pageSize, "cloudReviewTimeStart" => $cloudReviewTimeStart, "cloudReviewTimeEnd" => $cloudReviewTimeEnd, "plant" => $plant, "pull" => $pull, "state" => $state, "star" => $star, ]);
    }
    /**
     * 修图个人历史统计
     *
     */
    public static function getStatistics (string $cloudReviewTimeStart, string $cloudReviewTimeEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStatistics(["cloudReviewTimeStart" => $cloudReviewTimeStart, "cloudReviewTimeEnd" => $cloudReviewTimeEnd, ]);
    }
    /**
     * 提交流水
     *
     */
    public static function submitStream (int $retoucherStreamId, array $photoData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitStream(["retoucherStreamId" => $retoucherStreamId, "photoData" => $photoData, ]);
    }
    /**
     * api直接提交到云端
     *
     */
    public static function apiSubmitStream (string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->apiSubmitStream(["streamNum" => $streamNum, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}