<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-14 10:40:10
 */
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectCloud3rd";

    private static string $className = "Photographer\\Product";

    /**
     * 机构创建产品
     *
     */
    public static function addProduct (string $name, string $retouchRequire, array $simplePhotoPaths) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProduct(["name" => $name, "retouchRequire" => $retouchRequire, "simplePhotoPaths" => $simplePhotoPaths, ]);
    }
    /**
     * 机构再次提交产品
     *
     */
    public static function readdProduct (int $id, string $name, string $retouchRequire, array $simplePhotoPaths) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readdProduct(["id" => $id, "name" => $name, "retouchRequire" => $retouchRequire, "simplePhotoPaths" => $simplePhotoPaths, ]);
    }
    /**
     * 获取产品列表
     *
     */
    public static function getProductList (string $state, string $name = '', string $reviewPassAtStart = '', string $reviewPassAtEnd = '', int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["state" => $state, "name" => $name, "reviewPassAtStart" => $reviewPassAtStart, "reviewPassAtEnd" => $reviewPassAtEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取机构全部产品名称
     *
     */
    public static function getProductNameAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductNameAll();
    }
    /**
     * 获取产品详情
     *
     */
    public static function getProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProduct(["id" => $id, ]);
    }
    /**
     * 启用/禁用产品
     *
     */
    public static function switchProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->switchProduct(["id" => $id, ]);
    }
    /**
     * 产品通过审核结果回调
     *
     */
    public static function reviewPassCallback (int $cloudProductId, bool $needSplicing) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewPassCallback(["cloudProductId" => $cloudProductId, "needSplicing" => $needSplicing, ]);
    }
    /**
     * 产品审核拒绝结果回调
     *
     */
    public static function reviewRefuseCallback (int $cloudProductId, string $refuseReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewRefuseCallback(["cloudProductId" => $cloudProductId, "refuseReason" => $refuseReason, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}