<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-14 10:40:10
 */
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectCloud3rd";

    private static string $className = "Photographer\\Order";

    /**
     * 机构摄影师创建订单
     *
     */
    public static function addOrder (string $title, string $customerName, array $retouchClaim, string $takeTime, array $photoData, string $retouchNote = '', int $splitSize = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrder(["title" => $title, "customerName" => $customerName, "retouchClaim" => $retouchClaim, "takeTime" => $takeTime, "photoData" => $photoData, "retouchNote" => $retouchNote, "splitSize" => $splitSize, ]);
    }
    /**
     * onlyCreateOrder
     *
     */
    public static function onlyCreateOrder (int $photographerOrgId, int $photographerId, int $cloudOrderId, string $title, string $orderNum, array $streamNums, string $customerName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlyCreateOrder(["photographerOrgId" => $photographerOrgId, "photographerId" => $photographerId, "cloudOrderId" => $cloudOrderId, "title" => $title, "orderNum" => $orderNum, "streamNums" => $streamNums, "customerName" => $customerName, ]);
    }
    /**
     * 撤回订单
     *
     */
    public static function cancelOrder (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderNum" => $orderNum, ]);
    }
    /**
     * 获取上传历史记录列表
     *
     */
    public static function getOrderList (string $type, string $createdAtStart, string $createdAtEnd, string $title, string $customerName, string $orderNum, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderList(["type" => $type, "createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd, "title" => $title, "customerName" => $customerName, "orderNum" => $orderNum, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取上传历史记录详情
     *
     */
    public static function getOrder (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrder(["orderNum" => $orderNum, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}