<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method readdProductByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getProductNameAllByParams(array $params)
 * @method getProductByParams(array $params)
 * @method switchProductByParams(array $params)
 * @method reviewPassCallbackByParams(array $params)
 * @method reviewRefuseCallbackByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 机构创建产品
     *
     * @support  string $name 产品名 [ require false ]
     * @support  string $retouchRequire 修片要求 [ require false ]
     * @support  array $simplePhotoPaths 产品样片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct([
        ]);
    }

    /**
     * 机构再次提交产品
     *
     * @support  int $id 产品ID [ require true ]
     * @support  string $name 产品名 [ require true ]
     * @support  string $retouchRequire 修片要求 [ require false ]
     * @support  array $simplePhotoPaths 产品样片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readdProduct () {
        return self::getClass()->readdProduct([
        ]);
    }

    /**
     * 获取产品列表
     *
     * @support  string $state 搜索产品状态 [ require true ]
     * @support  string $name 搜索产品名 [ require false ]
     * @support  string $reviewPassAtStart 搜索通过时间起始 [ require false ]
     * @support  string $reviewPassAtEnd 搜索通过时间结束 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList([
        ]);
    }

    /**
     * 获取机构全部产品名称
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductNameAll () {
        return self::getClass()->getProductNameAll();
    }

    /**
     * 获取产品详情
     *
     * @support  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProduct () {
        return self::getClass()->getProduct([
        ]);
    }

    /**
     * 启用/禁用产品
     *
     * @support  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function switchProduct () {
        return self::getClass()->switchProduct([
        ]);
    }

    /**
     * 产品通过审核结果回调
     *
     * @support  int $cloudProductId 产品ID [ require true ]
     * @support  bool $needSplicing 是否需要拼接 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewPassCallback () {
        return self::getClass()->reviewPassCallback([
        ]);
    }

    /**
     * 产品审核拒绝结果回调
     *
     * @support  int $cloudProductId 产品ID [ require true ]
     * @support  string $refuseReason 拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewRefuseCallback () {
        return self::getClass()->reviewRefuseCallback([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}