<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrganizationInfoByParams(array $params)
 * @method personIncomeListByParams(array $params)
 * @method incomeDetailByParams(array $params)
 * @method qualityStatisticsByParams(array $params)
 * @method retoucherStatisticsByParams(array $params)
 * @method streamListByParams(array $params)
 * @method passByParams(array $params)
 * @method returnByParams(array $params)
 * @method getWaitReviewListByParams(array $params)
 * @method startReviewByParams(array $params)
 */
class Organization {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 机构基础信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrganizationInfo ($context) {
        return self::getClass()->getOrganizationInfo();
    }

    /**
     * 个人收益详情列表
     *
     * @support  string $cloudReviewTimeStart 时间起 [ require false ]
     * @support  string $cloudReviewTimeEnd 时间止 [ require false ]
     * @support  int $userId 每页条数 [ require false ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function personIncomeList ($context, int $page, int $pageSize) {
        return self::getClass()->personIncomeList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 机构收益详情
     *
     * @support  string $cloudReviewTimeStart 时间起 [ require false ]
     * @support  string $cloudReviewTimeEnd 时间止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incomeDetail ($context) {
        return self::getClass()->incomeDetail([
            "context" => $context,
        ]);
    }

    /**
     * 质量报告统计
     *
     * @support  string $cloudReviewTimeStart 时间起 [ require false ]
     * @support  string $cloudReviewTimeEnd 时间止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function qualityStatistics ($context) {
        return self::getClass()->qualityStatistics([
            "context" => $context,
        ]);
    }

    /**
     * 机构个人绩效
     *
     * @support  string $cloudReviewTimeStart 时间起 [ require false ]
     * @support  string $cloudReviewTimeEnd 时间止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retoucherStatistics ($context) {
        return self::getClass()->retoucherStatistics([
            "context" => $context,
        ]);
    }

    /**
     * 机构下流水列表
     *
     * @support  string $cloudReviewTimeStart 时间起 [ require false ]
     * @support  string $cloudReviewTimeEnd 时间止 [ require false ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  string $qualityType 质量统计类型 [ require false ]
     * @support  int $plant 种草流水[种草: 1] [ require false ]
     * @support  int $pull 拔草流水[拔草: 1] [ require false ]
     * @support  int $spotPull 抽查拔草流水[拔草: 1] [ require false ]
     * @support  int $spotPlant 抽查拔草流水[拔草: 1] [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamList ($context, int $page, int $pageSize) {
        return self::getClass()->streamList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 通过审核
     *
     * @param  int $retoucherStreamId 修图流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass ($context, int $retoucherStreamId) {
        return self::getClass()->pass([
            "context" => $context,
            "retoucherStreamId" => $retoucherStreamId,
        ]);
    }

    /**
     * 审核退回
     *
     * @param  int $retoucherStreamId 修图流水id [ require true ]
     * @param  array $photoData 退回照片 [ require true ]
     * @support  string $reviewNote 审核备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function return ($context, array $photoData, int $retoucherStreamId) {
        return self::getClass()->return([
            "context" => $context,
            "photoData" => $photoData,
            "retoucherStreamId" => $retoucherStreamId,
        ]);
    }

    /**
     * 审核列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  string $cloudStreamId 流水号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWaitReviewList ($context, int $page, int $pageSize) {
        return self::getClass()->getWaitReviewList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 开始审核
     *
     * @param  int $retoucherStreamId 修图流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startReview ($context, int $retoucherStreamId) {
        return self::getClass()->startReview([
            "context" => $context,
            "retoucherStreamId" => $retoucherStreamId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}