<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exitQueueByParams(array $params)
 * @method getOrderQueueByParams(array $params)
 * @method joinQueueByParams(array $params)
 * @method receiptStreamByParams(array $params)
 * @method consumeAgainByParams(array $params)
 * @method joinCloudQueueByParams(array $params)
 */
class OrderQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退出队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitQueue ($context) {
        return self::getClass()->exitQueue();
    }

    /**
     * state =&gt; wait : 已在排队
     * state =&gt; doing : 当前正在修片
     * 空 : 未在修片队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderQueue ($context) {
        return self::getClass()->getOrderQueue();
    }

    /**
     * 加入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinQueue ($context) {
        return self::getClass()->joinQueue();
    }

    /**
     * 从云端接单并分配至修图师(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiptStream () {
        return self::getClass()->receiptStream();
    }

    /**
     * 异步云端确认
     *
     * @param  int $orgId orgId [ require true ]
     * @param  string $cloudStreamId cloudStreamId [ require true ]
     * @param  string $nick nick [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeAgain (int $orgId, string $cloudStreamId, string $nick) {
        return self::getClass()->consumeAgain([
            "orgId" => $orgId,
            "cloudStreamId" => $cloudStreamId,
            "nick" => $nick,
        ]);
    }

    /**
     * 加入云端流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinCloudQueue () {
        return self::getClass()->joinCloudQueue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\OrderQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\OrderQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}