<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOrderByParams(array $params)
 * @method onlyCreateOrderByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 机构摄影师创建订单
     *
     * @support  string $title 订单标题 [ require true ]
     * @support  string $customerName 顾客姓名 [ require true ]
     * @support  array $retouchClaim 修片要求 [ require true ]
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $retouchNote 修图备注 [ require false ]
     * @param  int $splitSize 照片拆分流水【粒度】 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrder ($context, int $splitSize = 0) {
        return self::getClass()->addOrder([
            "context" => $context,
            "splitSize" => $splitSize,
        ]);
    }

    /**
     * 外部直接请求构建外包订单信息
     *
     * @support  int $photographerOrgId 摄影机构id [ require true ]
     * @support  int $photographerId 摄影师id [ require true ]
     * @support  int $cloudOrderId 云端订单ID [ require true ]
     * @support  string $title 订单标题 [ require true ]
     * @support  string $orderNum 外包订单号 [ require true ]
     * @support  array $streamNums 流水号s [ require true ]
     * @support  string $customerName 顾客名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlyCreateOrder ($context) {
        return self::getClass()->onlyCreateOrder([
            "context" => $context,
        ]);
    }

    /**
     * 撤回订单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelOrder ($context) {
        return self::getClass()->cancelOrder([
            "context" => $context,
        ]);
    }

    /**
     * 获取上传历史记录列表
     *
     * @support  string $type 搜索类型 [ require false ]
     * @support  string $createdAtStart 搜索起始时间 [ require false ]
     * @support  string $createdAtEnd 搜索结束时间 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $customerName 顾客姓名 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderList ($context) {
        return self::getClass()->getOrderList([
            "context" => $context,
        ]);
    }

    /**
     * 获取上传历史记录详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrder ($context) {
        return self::getClass()->getOrder([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}