<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUploadTokenByParams(array $params)
 * @method getHostByParams(array $params)
 * @method initRandomByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取表单上传签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 返回host
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 初始化随机数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function initRandom () {
        return self::getClass()->initRandom();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}