<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRetoucherStreamByParams(array $params)
 * @method getRetoucherStreamListByParams(array $params)
 * @method getStatisticsByParams(array $params)
 * @method submitStreamByParams(array $params)
 */
class RetoucherStream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取流水详情
     *
     * @param  int $retoucherStreamId 流水id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherStream (int $retoucherStreamId) {
        return self::getClass()->getRetoucherStream([
            "retoucherStreamId" => $retoucherStreamId,
        ]);
    }

    /**
     * 获取修片流水记录列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @support  string $cloudReviewTimeStart 时间起 
     * @support  string $cloudReviewTimeEnd 时间止 
     * @support  int $plant 种草流水[种草: 1] [Original type uint] 
     * @support  int $pull 拔草流水[拔草: 1] [Original type uint] 
     * @support  string $state 状态 enum:RetoucherStreamStateEnum 
     * @support  int $star 门店评分 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherStreamList (int $page, int $pageSize) {
        return self::getClass()->getRetoucherStreamList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 修图个人历史统计
     *
     * @support  string $cloudReviewTimeStart 时间起 
     * @support  string $cloudReviewTimeEnd 时间止 
     * @throws  \Exception
     * @return  array
     */
    public static function getStatistics () {
        return self::getClass()->getStatistics();
    }

    /**
     * 提交流水
     *
     * @param  int $retoucherStreamId 流水id [Original type uint] [ require true ]
     * @param  array $photoData 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitStream (int $retoucherStreamId, array $photoData) {
        return self::getClass()->submitStream([
            "retoucherStreamId" => $retoucherStreamId,
            "photoData" => $photoData,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\RetoucherStream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\RetoucherStream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}