<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrganizationInfoByParams(array $params)
 * @method incomeDetailByParams(array $params)
 * @method qualityStatisticsByParams(array $params)
 * @method qualityDetailByParams(array $params)
 * @method passByParams(array $params)
 * @method returnByParams(array $params)
 */
class Organization {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 机构基础信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrganizationInfo () {
        return self::getClass()->getOrganizationInfo();
    }

    /**
     * 机构收益详情列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @support  string $createdAtStart 时间起 
     * @support  string $createdAtEnd 时间止 
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function incomeDetail (int $page, int $pageSize) {
        return self::getClass()->incomeDetail([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 质量报告
     *
     * @throws  \Exception
     * @return  array
     */
    public static function qualityStatistics () {
        return self::getClass()->qualityStatistics();
    }

    /**
     * 质量报告列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function qualityDetail (string $type, int $page, int $pageSize) {
        return self::getClass()->qualityDetail([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * pass
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass () {
        return self::getClass()->pass();
    }

    /**
     * return
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function return () {
        return self::getClass()->return();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}