<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOrderByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 机构摄影师创建订单
     *
     * @support  string $title 订单标题 [ require true ]
     * @support  array $retouchClaim 修片要求 [ require true ]
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $retouchNote 修图备注 
     * @throws  \Exception
     * @return  string
     */
    public static function addOrder () {
        return self::getClass()->addOrder();
    }

    /**
     * 获取上传历史记录列表
     *
     * @support  string $type 搜索类型 
     * @support  string $createdAtStart 搜索起始时间 
     * @support  string $createdAtEnd 搜索结束时间 
     * @support  string $title 订单标题 
     * @support  string $orderNum 订单号 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 获取上传历史记录详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrder () {
        return self::getClass()->getOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}