<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userInfoByParams(array $params)
 * @method loginByPasswordByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 当前登录用户信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function userInfo () {
        return self::getClass()->userInfo();
    }

    /**
     * 检验用户名密码用于登录
     *
     * @param  string $username 用户名 [ require true ]
     * @param  string $password 用户名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function loginByPassword (string $username, string $password) {
        return self::getClass()->loginByPassword([
            "username" => $username,
            "password" => $password,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}