<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderQueueByParams(array $params)
 * @method joinQueueByParams(array $params)
 * @method receiveByParams(array $params)
 */
class OrderQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前排队信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderQueue () {
        return self::getClass()->getOrderQueue();
    }

    /**
     * 加入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinQueue () {
        return self::getClass()->joinQueue();
    }

    /**
     * receive
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receive () {
        return self::getClass()->receive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\OrderQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\OrderQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}