<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addUserByParams(array $params)
 * @method getUserListByParams(array $params)
 * @method getUserByParams(array $params)
 * @method editUserByParams(array $params)
 * @method disableByParams(array $params)
 * @method enableByParams(array $params)
 */
class SubUser {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建机构子账户
     *
     * @param  string $username 用户名 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @param  string $nick 摄影师昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addUser (string $username, string $password, string $nick) {
        return self::getClass()->addUser([
            "username" => $username,
            "password" => $password,
            "nick" => $nick,
        ]);
    }

    /**
     * 获取机构子账户列表
     *
     * @support  string $state 用户状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getUserList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取机构子账户详情
     *
     * @param  int $id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUser (int $id) {
        return self::getClass()->getUser([
            "id" => $id,
        ]);
    }

    /**
     * 修改机构子账户
     *
     * @param  int $id 用户id [Original type uint] [ require true ]
     * @param  string $username 用户名 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @param  string $nick 用户昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUser (int $id, string $username, string $password, string $nick) {
        return self::getClass()->editUser([
            "id" => $id,
            "username" => $username,
            "password" => $password,
            "nick" => $nick,
        ]);
    }

    /**
     * 禁用
     *
     * @param  int $id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disable (int $id) {
        return self::getClass()->disable([
            "id" => $id,
        ]);
    }

    /**
     * 启用
     *
     * @param  int $id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enable (int $id) {
        return self::getClass()->enable([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\SubUser');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\SubUser');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}