<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addMasterByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * addMaster
     *
     * @param  string $name 机构名称 [ require true ]
     * @param  string $code 机构代号 [ require true ]
     * @param  string $account 机构账户 [ require true ]
     * @param  string $secret 机构密钥 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addMaster (string $name, string $code, string $secret, string $account) {
        return self::getClass()->addMaster([
            "name" => $name,
            "code" => $code,
            "secret" => $secret,
            "account" => $account,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}