<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method organizationInfoByParams(array $params)
 * @method incomeDetailByParams(array $params)
 */
class Organization {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * organizationInfo
     *
     * @throws  \Exception
     * @return  array
     */
    public static function organizationInfo () {
        return self::getClass()->organizationInfo();
    }

    /**
     * incomeDetail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function incomeDetail () {
        return self::getClass()->incomeDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\Organization');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}