<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Retoucher;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orgChangeByParams(array $params)
 * @method addMasterByParams(array $params)
 * @method startReviewByParams(array $params)
 * @method urgentByParams(array $params)
 * @method reviewPassByParams(array $params)
 * @method reviewReturnByParams(array $params)
 * @method finishByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * orgChange
     *
     * @param  string $name 机构名称 [ require true ]
     * @param  string $code 机构代号 [ require true ]
     * @param  string $account 机构账户 [ require true ]
     * @param  string $secret 机构密钥 [ require true ]
     * @support  array $income_config 机构代号 [ require true ]
     * @param  bool $state 机构状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orgChange (string $name, string $code, string $secret, string $account, bool $state) {
        return self::getClass()->orgChange([
            "name" => $name,
            "code" => $code,
            "secret" => $secret,
            "account" => $account,
            "state" => $state,
        ]);
    }

    /**
     * addMaster
     *
     * @param  string $name 机构名称 [ require true ]
     * @param  string $code 机构代号 [ require true ]
     * @param  string $account 机构账户 [ require true ]
     * @param  string $secret 机构密钥 [ require true ]
     * @param  array $income_config 机构代号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addMaster (string $name, string $code, string $secret, array $income_config, string $account) {
        return self::getClass()->addMaster([
            "name" => $name,
            "code" => $code,
            "secret" => $secret,
            "income_config" => $income_config,
            "account" => $account,
        ]);
    }

    /**
     * startReview
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startReview (string $stream_num) {
        return self::getClass()->startReview([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * urgent
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgent (string $stream_num) {
        return self::getClass()->urgent([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * reviewPass
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  array $tags 标签 [ require true ]
     * @param  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewPass (string $stream_num, array $photos, array $tags = []) {
        return self::getClass()->reviewPass([
            "stream_num" => $stream_num,
            "photos" => $photos,
            "tags" => $tags,
        ]);
    }

    /**
     * reviewReturn
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  array $return_photos 退回照片 [ require true ]
     * @param  array $tags 标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewReturn (string $stream_num, array $return_photos, array $tags = []) {
        return self::getClass()->reviewReturn([
            "stream_num" => $stream_num,
            "return_photos" => $return_photos,
            "tags" => $tags,
        ]);
    }

    /**
     * 看片审核完成
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  int $score 评分 [ require true ]
     * @param  string $note 评语 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish (string $stream_num, int $score, string $note = '') {
        return self::getClass()->finish([
            "stream_num" => $stream_num,
            "score" => $score,
            "note" => $note,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Retoucher\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Retoucher\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}