<?php
namespace Mainto\Bridge\Invokes\ProjectCloud3rd\Photographer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addUserByParams(array $params)
 * @method getUserListByParams(array $params)
 * @method getUserByParams(array $params)
 * @method modifyUserByParams(array $params)
 */
class SubUser {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建机构子账户
     *
     * @support  string $name 用户名 [ require true ]
     * @support  string $password 用户密码 [ require true ]
     * @support  string $nick 用户昵称 [ require true ]
     * @support  int $group 用户组 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function addUser () {
        return self::getClass()->addUser();
    }

    /**
     * 获取机构子账户列表
     *
     * @support  string $state 用户状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserList () {
        return self::getClass()->getUserList();
    }

    /**
     * 获取机构子账户详情
     *
     * @support  int $id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUser () {
        return self::getClass()->getUser();
    }

    /**
     * 修改机构子账户
     *
     * @support  string $name 用户名 
     * @support  string $password 用户密码 
     * @support  string $nick 用户昵称 
     * @support  int $group 用户组 [Original type uint] 
     * @support  string $state 用户状态 
     * @throws  \Exception
     * @return  string
     */
    public static function modifyUser () {
        return self::getClass()->modifyUser();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud3rd', 'Photographer\SubUser');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud3rd', 'Photographer\SubUser');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}