<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method urgentStreamByParams(array $params)
 * @method getRetouchStreamListByParams(array $params)
 * @method getQueueStreamListByParams(array $params)
 * @method queueStreamListCountByParams(array $params)
 * @method getStreamListByParams(array $params)
 * @method getFlowInfoByParams(array $params)
 * @method getCloudRetoucherQuotaByParams(array $params)
 * @method editRetoucherGroupTargetQuotaByParams(array $params)
 * @method getRetoucherQuotaByParams(array $params)
 * @method getAllCloudStreamByParams(array $params)
 * @method getWholeQuotaByParams(array $params)
 * @method getCheckPoolQuotaByParams(array $params)
 * @method getCheckPoolSubQuotaByParams(array $params)
 * @method getStreamTimesQuotaByParams(array $params)
 * @method getOrgStandardTimesQuotaByParams(array $params)
 * @method getStoreReturnQuotaByParams(array $params)
 * @method getReviewQuotaByParams(array $params)
 * @method getStoreEvaluateByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method modifyStreamByParams(array $params)
 * @method addRetouchOrgByParams(array $params)
 * @method enableRetouchOrgByParams(array $params)
 * @method disableRetouchOrgByParams(array $params)
 * @method editRetouchOrgByParams(array $params)
 * @method getRetouchOrgInfoByParams(array $params)
 * @method getRetouchOrgListByParams(array $params)
 * @method addPhotographerOrgByParams(array $params)
 * @method editPhotographerOrgByParams(array $params)
 * @method getPhotographerOrgListByParams(array $params)
 * @method enablePhotographerOrgByParams(array $params)
 * @method disablePhotographerOrgByParams(array $params)
 * @method getPhotographerOrgInfoByParams(array $params)
 * @method getRetouchOrgIncomeByParams(array $params)
 * @method setSupervisorOnDutyByParams(array $params)
 * @method getSupervisorOnDutyByParams(array $params)
 * @method manualReviewByParams(array $params)
 * @method batchSaveStaffScoresByParams(array $params)
 * @method editStaffScoreByParams(array $params)
 * @method getStaffScoresByParams(array $params)
 */
class Operator {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目前开放给门店店长order.shot.unbind_user加急使用
     *
     * @param  int $streamId 流水id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentStream (int $streamId) {
        return self::getClass()->urgentStream([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取修片流水列表
     *
     * @support  string $retoucherStandard 修图标准 
     * @support  string $streamState 流水状态 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchStreamList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRetouchStreamList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取修片队列流水列表
     *
     * @support  string $retoucherStandard 修图标准 
     * @param  string $streamState 流水状态 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQueueStreamList (string $streamState, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getQueueStreamList([
            "streamState" => $streamState,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 目前开放给门店云端队列使用
     *
     * @throws  \Exception
     * @return  array
     */
    public static function queueStreamListCount () {
        return self::getClass()->queueStreamListCount();
    }

    /**
     * 目前开放给门店店长order.shot.unbind_user加急使用
     *
     * @support  string $customerName 顾客姓名 
     * @support  string $orderNum 订单号【外部订单号】 
     * @support  string $streamNum 流水号 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStreamList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取流水看板数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getFlowInfo () {
        return self::getClass()->getFlowInfo();
    }

    /**
     * 获取云端工作指标
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudRetoucherQuota () {
        return self::getClass()->getCloudRetoucherQuota();
    }

    /**
     * 延后做
     *
     * @param  int $expectPhotoNum 预计完成照片数 [Original type uint] [ require true ]
     * @param  int $groupId 修图组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetoucherGroupTargetQuota (int $expectPhotoNum, int $groupId) {
        return self::getClass()->editRetoucherGroupTargetQuota([
            "expectPhotoNum" => $expectPhotoNum,
            "groupId" => $groupId,
        ]);
    }

    /**
     * 获取伙伴绩效
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  array $staffIds 伙伴id 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherQuota () {
        return self::getClass()->getRetoucherQuota();
    }

    /**
     * 云端全流水查询&lt;2.10更新接口&gt;
     *
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @support  string $evaluate 门店点赞 
     * @support  string $storeReworkType 门店退回 
     * @param  array $retoucherIds 筛选人员 [ require true ]
     * @support  array $cloudTags 云学院问题标签 
     * @support  string $cloudEvaluateType 云学院标签类型 
     * @support  string $passStartAt 审核通过开始时间 
     * @support  string $passEndAt 审核通过结束时间 
     * @support  string $returnStartAt 门店退回开始时间 
     * @support  string $returnEndAt 门店退回结束时间 
     * @support  string $storeEvaluateStartAt 门店评价开始时间 
     * @support  string $storeEvaluateEndAt 门店评价结束时间 
     * @support  string $cloudEvaluateStartAt 云学院评价开始时间 
     * @support  string $cloudEvaluateEndAt 云学院评价结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllCloudStream (int $page, int $pageSize, array $retoucherIds = []) {
        return self::getClass()->getAllCloudStream([
            "page" => $page,
            "pageSize" => $pageSize,
            "retoucherIds" => $retoucherIds,
        ]);
    }

    /**
     * 获取总体绩效&lt;2.10更新接口&gt;
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWholeQuota () {
        return self::getClass()->getWholeQuota();
    }

    /**
     * 获取云学院报告绩效&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $retoucherIds 云端伙伴id [ require true ]
     * @param  array $productIds 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return self::getClass()->getCheckPoolQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retoucherIds" => $retoucherIds,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取云学院报告绩效&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  string $type 打分类型 [ require true ]
     * @param  array $retoucherIds 云端伙伴id [ require true ]
     * @param  array $productIds 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt, string $type = '', array $retoucherIds = [], array $productIds = []) {
        return self::getClass()->getCheckPoolSubQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "type" => $type,
            "retoucherIds" => $retoucherIds,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  int $retouchGroup 修片组别id [ require true ]
     * @param  string $retouchClass 修图类别id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0, string $retouchClass = '') {
        return self::getClass()->getStreamTimesQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retouchGroup" => $retouchGroup,
            "retouchClass" => $retouchClass,
        ]);
    }

    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  int $retouchGroup 修片组别id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrgStandardTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0) {
        return self::getClass()->getOrgStandardTimesQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retouchGroup" => $retouchGroup,
        ]);
    }

    /**
     * 获取门店退回指标&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $retouchIds 修片师id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreReturnQuota (string $startAt, string $endAt, array $retouchIds = []) {
        return self::getClass()->getStoreReturnQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retouchIds" => $retouchIds,
        ]);
    }

    /**
     * 获取审核绩效[审与被审]
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @support  int $reviewId 审核人id [Original type uint] 
     * @support  int $groupId 修图组id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewQuota (string $startAt, string $endAt) {
        return self::getClass()->getReviewQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * 获取门店评价
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  int $staffId 伙伴id [Original type uint] 
     * @support  string $storeEvaluation 评分 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreEvaluate (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStoreEvaluate([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取流水信息【只能查到未审核通过流水】
     *
     * @support  string $externalNum 订单号[外部订单号] 
     * @support  string $streamNum 流水号 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo () {
        return self::getClass()->getStreamInfo();
    }

    /**
     * 更改流水信息【只能修改未审核通过流水】
     *
     * @param  int $streamId 流水id [ require true ]
     * @param  array $photos 修改照片数据 [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyStream (int $streamId, array $photos, int $productId) {
        return self::getClass()->modifyStream([
            "streamId" => $streamId,
            "photos" => $photos,
            "productId" => $productId,
        ]);
    }

    /**
     * 添加修图机构
     *
     * @support  string $name 机构名 [ require true ]
     * @support  string $code 机构代号 [ require true ]
     * @support  string $account 机构主账号 [ require true ]
     * @support  string $secret 机构密码 
     * @support  array $enableProductIds 可接产品 [ require true ]
     * @support  array $incomeConfig 收益配置 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRetouchOrg () {
        return self::getClass()->addRetouchOrg();
    }

    /**
     * 启动修图机构
     *
     * @param  int $retouchOrgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableRetouchOrg (int $retouchOrgId) {
        return self::getClass()->enableRetouchOrg([
            "retouchOrgId" => $retouchOrgId,
        ]);
    }

    /**
     * 禁用修图机构
     *
     * @param  int $retouchOrgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableRetouchOrg (int $retouchOrgId) {
        return self::getClass()->disableRetouchOrg([
            "retouchOrgId" => $retouchOrgId,
        ]);
    }

    /**
     * 修改修图机构
     *
     * @param  int $retouchOrgId 机构id [Original type uint] [ require true ]
     * @support  string $name 机构名 [ require true ]
     * @support  string $code 机构代号 [ require true ]
     * @support  string $account 机构主账号 [ require true ]
     * @param  string $secret 机构密码 [ require true ]
     * @param  array $enableProductIds 可接产品 [ require true ]
     * @support  array $incomeConfig 收益配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetouchOrg (int $retouchOrgId, array $enableProductIds, string $secret = NULL) {
        return self::getClass()->editRetouchOrg([
            "retouchOrgId" => $retouchOrgId,
            "enableProductIds" => $enableProductIds,
            "secret" => $secret,
        ]);
    }

    /**
     * 获取修图机构信息
     *
     * @param  int $retouchOrgId 机构id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgInfo (int $retouchOrgId) {
        return self::getClass()->getRetouchOrgInfo([
            "retouchOrgId" => $retouchOrgId,
        ]);
    }

    /**
     * 获取修图机构列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgList () {
        return self::getClass()->getRetouchOrgList();
    }

    /**
     * 添加摄影机构
     *
     * @support  string $name 机构名 [ require true ]
     * @support  string $code 机构代号 
     * @support  string $account 机构主账号 
     * @support  string $secret 机构密码 
     * @support  string $type 登录方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotographerOrg () {
        return self::getClass()->addPhotographerOrg();
    }

    /**
     * 修改摄影机构
     *
     * @param  int $photographerOrgId 机构id [ require true ]
     * @support  string $name 机构名 [ require true ]
     * @support  string $type 登录方式 [ require true ]
     * @support  string $account 机构主账号 
     * @support  string $secret 机构密码 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editPhotographerOrg (int $photographerOrgId) {
        return self::getClass()->editPhotographerOrg([
            "photographerOrgId" => $photographerOrgId,
        ]);
    }

    /**
     * 获取摄影机构列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographerOrgList () {
        return self::getClass()->getPhotographerOrgList();
    }

    /**
     * 启用摄影机构
     *
     * @param  int $photographerOrgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enablePhotographerOrg (int $photographerOrgId) {
        return self::getClass()->enablePhotographerOrg([
            "photographerOrgId" => $photographerOrgId,
        ]);
    }

    /**
     * 禁用摄影机构
     *
     * @param  int $photographerOrgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disablePhotographerOrg (int $photographerOrgId) {
        return self::getClass()->disablePhotographerOrg([
            "photographerOrgId" => $photographerOrgId,
        ]);
    }

    /**
     * 获取摄影机构信息
     *
     * @param  int $photographerOrgId 机构id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographerOrgInfo (int $photographerOrgId) {
        return self::getClass()->getPhotographerOrgInfo([
            "photographerOrgId" => $photographerOrgId,
        ]);
    }

    /**
     * 获取修图机构绩效
     *
     * @support  int $retoucherOrgId 机构id 
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 开始时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgIncome () {
        return self::getClass()->getRetouchOrgIncome();
    }

    /**
     * 设置值班主管
     *
     * @param  array $supervisorOnDutyData 值班主管信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSupervisorOnDuty (array $supervisorOnDutyData) {
        return self::getClass()->setSupervisorOnDuty([
            "supervisorOnDutyData" => $supervisorOnDutyData,
        ]);
    }

    /**
     * 获取值班主管
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSupervisorOnDuty () {
        return self::getClass()->getSupervisorOnDuty();
    }

    /**
     * 手动直接审核
     *
     * @param  int $streamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function manualReview (int $streamId) {
        return self::getClass()->manualReview([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 批量保存staff打分信息-不检查staffId-2.8
     *
     * @support  array $staffScores staffScores [ require true ]
     * @support  string $type 该次评分的针对对象 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSaveStaffScores () {
        return self::getClass()->batchSaveStaffScores();
    }

    /**
     * 编辑staff分数-不检查staffId-2.8
     *
     * @support  int $id 记录id [Original type uint] [ require true ]
     * @support  float $score 新分数 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaffScore () {
        return self::getClass()->editStaffScore();
    }

    /**
     * 获取staff分数列表-不检查staffId-2.8
     *
     * @support  string $cycle 周期 [ require true ]
     * @support  array $staffIds 伙伴ids 
     * @support  string $type 该次评分的针对对象 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffScores (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getStaffScores([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Operator');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Operator');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}