<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHourGlassListByParams(array $params)
 * @method getBaseHourGlassSettingByParams(array $params)
 * @method getHourGlassInfoByParams(array $params)
 * @method enableHourGlassGlobalStateByParams(array $params)
 * @method disableHourGlassGlobalStateByParams(array $params)
 * @method addHourGlassByParams(array $params)
 * @method editHourGlassByParams(array $params)
 * @method deleteHourGlassByParams(array $params)
 * @method addCardByParams(array $params)
 * @method closeCardByParams(array $params)
 * @method deleteCardByParams(array $params)
 * @method getStaffCardListByParams(array $params)
 * @method getImpulseListByParams(array $params)
 * @method addImpulseByParams(array $params)
 * @method addImpulseSettingItemByParams(array $params)
 * @method delImpulseSettingItemByParams(array $params)
 * @method getImpulseSettingItemListByParams(array $params)
 * @method getImpulseInfoByParams(array $params)
 * @method deleteImpulseByParams(array $params)
 * @method disableImpulseByParams(array $params)
 * @method getGreenChannelInfoByParams(array $params)
 * @method saveGreenChannelInfoByParams(array $params)
 * @method getSuggestWorkloadByParams(array $params)
 * @method saveSuggestWorkloadByParams(array $params)
 * @method addTimeIntervalRewardConfigByParams(array $params)
 * @method getTimeIntervalRewardConfigByParams(array $params)
 * @method stopTimeIntervalRewardConfigByParams(array $params)
 * @method getTimeIntervalRewardConfigListByParams(array $params)
 */
class Config {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取沙漏列表[产品沙漏]
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHourGlassList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getHourGlassList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取基础沙漏列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseHourGlassSetting (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getBaseHourGlassSetting([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取沙漏详情
     *
     * @param  int $configId 配置id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHourGlassInfo (int $configId) {
        return self::getClass()->getHourGlassInfo([
            "configId" => $configId,
        ]);
    }

    /**
     * 开启全局沙漏状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableHourGlassGlobalState () {
        return self::getClass()->enableHourGlassGlobalState();
    }

    /**
     * 关闭全局沙漏状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableHourGlassGlobalState () {
        return self::getClass()->disableHourGlassGlobalState();
    }

    /**
     * 添加沙漏
     *
     * @support  string $retouchStandard 修图标准 
     * @support  array $productIds 产品ids 
     * @support  array $staffRanges 伙伴范围 [ require true ]
     * @support  int $baseTime 基础时间[秒] [ require true ]
     * @support  int $superimposedTime 叠加时间[秒] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addHourGlass () {
        return self::getClass()->addHourGlass();
    }

    /**
     * 编辑沙漏
     *
     * @param  int $configId 配置id [ require true ]
     * @param  string $retouchStandard 修图标准 [ require true ]
     * @param  array $productIds 产品ids [ require true ]
     * @param  array $staffRanges 伙伴范围 [ require true ]
     * @param  int $baseTime 基础时间[分钟] [ require true ]
     * @param  int $superimposedTime 叠加时间[分钟] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editHourGlass (int $configId, string $retouchStandard, array $productIds, array $staffRanges, int $baseTime, int $superimposedTime) {
        return self::getClass()->editHourGlass([
            "configId" => $configId,
            "retouchStandard" => $retouchStandard,
            "productIds" => $productIds,
            "staffRanges" => $staffRanges,
            "baseTime" => $baseTime,
            "superimposedTime" => $superimposedTime,
        ]);
    }

    /**
     * 删除沙漏
     *
     * @param  int $configId 配置id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteHourGlass (int $configId) {
        return self::getClass()->deleteHourGlass([
            "configId" => $configId,
        ]);
    }

    /**
     * 添加伙伴卡片配置
     *
     * @param  string $type 卡片类型 [ require true ]
     * @param  float $multiple 倍数 [Original type double] [ require true ]
     * @param  array $staffIds 伙伴id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addCard (string $type, float $multiple, array $staffIds) {
        return self::getClass()->addCard([
            "type" => $type,
            "multiple" => $multiple,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 关闭卡片配置
     *
     * @param  int $staffCardId 伙伴的某张卡片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeCard (int $staffCardId) {
        return self::getClass()->closeCard([
            "staffCardId" => $staffCardId,
        ]);
    }

    /**
     * 删除卡片配置
     *
     * @param  int $staffCardId 伙伴的某张卡片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCard (int $staffCardId) {
        return self::getClass()->deleteCard([
            "staffCardId" => $staffCardId,
        ]);
    }

    /**
     * 获取已配置卡片列表
     *
     * @support  string $type 状态 [ require true ]
     * @support  string $state 状态 
     * @support  array $staffIds 伙伴id 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffCardList (int $page, int $pageSize) {
        return self::getClass()->getStaffCardList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取已配置冲量奖励列表
     *
     * @support  string $state 状态 
     * @support  array $staffIds 伙伴ID数组 
     * @support  array $retoucherOrgIds 修片机构id数据 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getImpulseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 新增冲量奖励
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $staffIds 伙伴id数组 
     * @support  array $retoucherOrgIds 修图机构id数组 
     * @support  array $settingItemIds 配置id数据 [ require true ]
     * @support  string $startAt 生效日期 [ require true ]
     * @support  string $endAt 结束日期 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addImpulse () {
        return self::getClass()->addImpulse();
    }

    /**
     * 新增冲量奖励配置
     *
     * @support  float $reachExp 需要的海草 [Original type unsignedDouble] [ require true ]
     * @support  string $type 配置类型:常规配置 时段配置 [ require true ]
     * @support  float $reward 配置id [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addImpulseSettingItem () {
        return self::getClass()->addImpulseSettingItem();
    }

    /**
     * 删除冲量奖励配置
     *
     * @param  int $itemId 冲量奖励配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delImpulseSettingItem (int $itemId) {
        return self::getClass()->delImpulseSettingItem([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 获取冲量奖励配置项列表
     *
     * @support  string $type 配置类型:常规配置 时段配置 
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseSettingItemList () {
        return self::getClass()->getImpulseSettingItemList();
    }

    /**
     * 获取冲量奖励详情
     *
     * @param  int $impulseId 配置id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseInfo (int $impulseId) {
        return self::getClass()->getImpulseInfo([
            "impulseId" => $impulseId,
        ]);
    }

    /**
     * 删除冲量奖励
     *
     * @param  int $impulseId 配置id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteImpulse (int $impulseId) {
        return self::getClass()->deleteImpulse([
            "impulseId" => $impulseId,
        ]);
    }

    /**
     * 关闭冲量奖励
     *
     * @param  int $impulseId 配置id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableImpulse (int $impulseId) {
        return self::getClass()->disableImpulse([
            "impulseId" => $impulseId,
        ]);
    }

    /**
     * 获取绿色通道人员
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGreenChannelInfo () {
        return self::getClass()->getGreenChannelInfo();
    }

    /**
     * 更新绿色通道人员
     *
     * @param  array $staffIds 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveGreenChannelInfo (array $staffIds = []) {
        return self::getClass()->saveGreenChannelInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取建议工作量
     *
     * @param  int $retouchClassId 修图类别id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuggestWorkload (int $retouchClassId) {
        return self::getClass()->getSuggestWorkload([
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * 保存建议工作量
     *
     * @param  int $retouchClassId 修图类别id [ require true ]
     * @support  array $suggestWorkload 建议工作量 
     * @throws  \Exception
     * @return  array
     */
    public static function saveSuggestWorkload (int $retouchClassId) {
        return self::getClass()->saveSuggestWorkload([
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * 创建时段配置
     *
     * @support  string $title 标题 [ require true ]
     * @param  string $type 配置类型 [ require true ]
     * @support  array $settingItemIds 配置项数组 
     * @support  array $staffIds 用户数组 [ require true ]
     * @support  string $beginAt 生效开始时刻 [ require true ]
     * @support  string $endAt 生效结束时刻 [ require true ]
     * @support  float $exp 经验倍率 [Original type double] 
     * @support  float $gold 金币倍率 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addTimeIntervalRewardConfig (string $type) {
        return self::getClass()->addTimeIntervalRewardConfig([
            "type" => $type,
        ]);
    }

    /**
     * 获取时段配置详情
     *
     * @param  int $id 主键 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTimeIntervalRewardConfig (int $id) {
        return self::getClass()->getTimeIntervalRewardConfig([
            "id" => $id,
        ]);
    }

    /**
     * 奖励配置停止
     *
     * @param  int $id 主键 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stopTimeIntervalRewardConfig (int $id) {
        return self::getClass()->stopTimeIntervalRewardConfig([
            "id" => $id,
        ]);
    }

    /**
     * 获取时段配置列表
     *
     * @param  array $conds 查询条件 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @support  string $conds.stateEqual 状态查询条件 
     * @support  int $conds.creatorId 创建人查询条件 [Original type uint] 
     * @support  string $conds.typeEqual 类型查询条件 
     * @support  string $conds.titleLike 标题模糊查询条件 
     * @throws  \Exception
     * @return  array
     */
    public static function getTimeIntervalRewardConfigList (int $page = 1, int $pageSize = 10, array $conds = []) {
        return self::getClass()->getTimeIntervalRewardConfigList([
            "page" => $page,
            "pageSize" => $pageSize,
            "conds" => $conds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Config');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Config');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}